<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van RCMR_IN010017NL - Retrieve Consents Query</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="attentionLine" id="RCMR_IN010017NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:queryByParameter/hl7:patientId/hl7:value"/>
        <param name="attentionLineOptional" value="'false'"/>
    </pattern>
    
    <pattern is-a="transmission-wrapper" id="RCMR_IN010017NL-wrapper">
        <param name="element" value="hl7:RCMR_IN010017NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="RCMR_IN010017NL-controlAct">
        <param name="element" value="hl7:RCMR_IN010017NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:RCMR_IN010017NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:RCMR_IN010017NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- ontvanger -->
        <rule context="hl7:RCMR_IN010017NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >Ontvanger moet de ZIM zijn.</assert>
        </rule>
    </pattern>

    <pattern>
        <!-- patientId -->
        <rule context="hl7:queryByParameter">
            <report role="warning" test="hl7:modifyCode">modifyCode mag wel voorkomen, maar wordt niet meegenomen in de verwerking van de interactie.</report>
            <assert role="error" test="hl7:responseModalityCode/@code='R'">responseModalityCode moet vaste waarde 'R' hebben.</assert>
            <report role="warning" test="hl7:initialQuantity">initialQuantity mag wel voorkomen, maar wordt niet meegenomen in de verwerking van de interactie.</report>
            <report role="warning" test="hl7:initialQuantityCode">initialQuantityCode mag wel voorkomen, maar wordt niet meegenomen in de verwerking van de interactie.</report>
        </rule>
        <rule context="hl7:patientId/hl7:value">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.3'"
                >@root van patientID moet '2.16.840.1.113883.2.4.6.3' zijn</assert>
        </rule>
        <rule context="hl7:registrationProcessEffectiveTime">
            <report role="warning" test="hl7:value/hl7:width"
                >width in registrationProcessEffectiveTime wordt niet ondersteund, low en/of high zijn wel toegestaan</report>
        </rule>
        
    </pattern>
</schema>
